BEGIN;
CREATE TABLE `releasenotes_release` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `modified` datetime NOT NULL,
    `v1` smallint UNSIGNED NOT NULL,
    `v2` smallint UNSIGNED NOT NULL,
    `v3` smallint UNSIGNED NOT NULL,
    `v4` smallint UNSIGNED NULL,
    `sort_value` integer UNSIGNED NOT NULL UNIQUE,
    UNIQUE (`v1`, `v2`, `v3`, `v4`)
);
CREATE TABLE `releasenotes_note` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `modified` datetime NOT NULL,
    `created` datetime NOT NULL,
    `ticket` integer UNSIGNED NOT NULL,
    `kind` smallint UNSIGNED NOT NULL,
    `release_beginn_id` integer NULL REFERENCES `releasenotes_release` (`id`),
    `release_behoben_id` integer NULL REFERENCES `releasenotes_release` (`id`),
    `last_modified_by` integer NULL,
    UNIQUE (`ticket`, `release_behoben_id`),
    UNIQUE (`ticket`, `release_beginn_id`)
);
CREATE TABLE `releasenotes_lastsync` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `timestamp` datetime NOT NULL
);
CREATE TABLE `releasenotes_notetext` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `modified` datetime NOT NULL,
    `language` varchar(7) NULL,
    `text` longtext NOT NULL,
    `note_id` integer NOT NULL REFERENCES `releasenotes_note` (`id`),
    UNIQUE (`note_id`, `language`)
);
CREATE INDEX releasenotes_note_release_beginn_id ON `releasenotes_note` (`release_beginn_id`);
CREATE INDEX releasenotes_note_release_behoben_id ON `releasenotes_note` (`release_behoben_id`);
CREATE INDEX releasenotes_notetext_note_id ON `releasenotes_notetext` (`note_id`);
COMMIT;

grant select, update, insert, delete on releasenotes_release to kundebunt;
grant select, update, insert, delete on releasenotes_note to kundebunt;
grant select, update, insert, delete on releasenotes_lastsync to kundebunt;
grant select, update, insert, delete on releasenotes_notetext to kundebunt;
