
# use strict;
# use warnings;
use utf8;
use Test::More tests => 4;
use Data::Dump qw(pp);
use NorisOtrsReport::QuelleProcessor;

sub test_opcall_cmp {
    ($NorisOtrsReport::QuelleProcessor::a,
     $NorisOtrsReport::QuelleProcessor::b) = @_;
    return NorisOtrsReport::QuelleProcessor::opcall_cmp();
}

is test_opcall_cmp(
        {PrioQuelle => 1,  Verursacher => 'Z'},
        {PrioQuelle => '02', Verursacher => 'A'}),
    -1, 
    'opcall_cmp 1: nach PrioQuelle, 1 vor 9';
   
is test_opcall_cmp(
        {PrioQuelle => 3, Verursacher => 'D', IncidentStartEpoch => 99},
        {PrioQuelle => 3, Verursacher => 'E', IncidentStartEpoch => 1}),
    -1,
    'opcall_cmp 2: nach Verursacher, A vor Z';
    
is test_opcall_cmp(
        {PrioQuelle => '03', Verursacher => 'D', IncidentStartEpoch => 5},
        {PrioQuelle => 3,    Verursacher => 'D', IncidentStartEpoch => 11}),
    1,
    'opcall_cmp 3: nach IncidentStartEpoch, 9 vor 1';
    
is test_opcall_cmp(
        {PrioQuelle => '8', Verursacher => 'Z', IncidentStartEpoch => 999},
        {}),
    -1,
    'opcall_cmp 4: Tickets ohne Angaben kommen zuletzt';

