has use strict;
use warnings;
use utf8;

package TicketState;
use Moose;
use TicketStateType;
use TicketDate;

has 'id' => (isa => 'Int', is => 'ro', required => 1);
has 'name' => (isa => 'Str', is => 'ro', required => 1);
has 'type' => (isa => 'TicketStateType', is => 'ro', required => 1);
has 'until' => (isa => 'TicketDate', is => 'ro');

sub xml { 
    my ($Self) = @_;
    my ($id, $name, $type_id, $type_name, $until) = 
        ($Self->id(), $Self->name(), $Self->type()->id(), 
         $Self->type()->name(), $Self->until() && $Self->until()->xml());
    return qq(<state type_id="$type_id" type="$type_name"><status id="$id">$name</status>$until</state>);
}
