use strict;
use warnings;
use utf8;

package TicketFreeText;
use Moose;

has 'id' => (isa => 'Int', is => 'ro', required => 1);
has 'key' => (isa => 'Str', is => 'ro', required => 1);
has 'value' => (isa => 'Str', is => 'ro', required => 1);

sub xml {
    my ($Self) = @_;
    my ($id, $key, $value) = 
        ($Self->id(), $Self->key(), $Self->value() && xmlq($Self->value()));
    return qq(<customtext id="$id" key="$key">$value</customtext>);
}
sub is_defined { return defined $_->value(); }
