use strict;
use warnings;
use utf8;

package TicketDate;
use DateTime;

use Moose;
use Moose::Util::TypeConstraints;

subtype 'DateTime' 
    => as 'Object' 
    => where { $_->isa('DateTime') };

coerce 'DateTime' 
    => from 'Int'
        => via { DateTime->from_epoch( epoch => $_ ); }
    => from 'HashRef'
        => via { DateTime->new( $_ ); }
    ;

has 'dateTime' => (is => 'ro', isa => 'DateTime', coerce => 1, required => 1);

sub xml { 
    my ($Self) = @_;
    my $dt = $Self->dateTime();
    my ($y,$m,$d,$h,$min,$sec) = map $dt->$_, qw(year month day hour minute second);
    my %d = map +($_ => $dt->$_), qw(year ...);
    my ($y,$m,$d,$h,$min,$sec) = ($dt->year(), $dt->month(), $dt->day(), $dt->hour(), $dt->minute(), $dt->second());
    return <<_;
    <date year="$y" month="$m" day="$d" hour="$h" minute="$min" second="$sec" />
_
}
