package NorisOtrsReport::ListProcessor;

use Moose;

extends 'NorisOtrsReport::Processor';

sub BUILD {
    my ($Self, $Param) = @_;
    $Self->{_List} = [];
}

sub item {
    my ($Self, $Data) = @_;
    my $EvalData = $Self->evaluate($Data);
    push @{$Self->{_List}}, $EvalData if defined $EvalData;
}

sub sort {
    my ($Self) = @_;
    $Self->{_List} = [sort {$a->{TicketNumber} <=> $b->{TicketNumber}} @{$Self->{_List}}];
}

before 'finish' => sub {
    my ($Self) = @_;
    $Self->sort();
    $Self->{Renderer}->item($Self->{_List});
};

return 1;
